/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.gdal;

import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Vector;
import org.gdal.gdal.Attribute;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.ExtendedDataType;
import org.gdal.gdal.ProgressCallback;
import org.gdal.gdal.SWIGTYPE_p_GUIntBig;
import org.gdal.gdal.Statistics;
import org.gdal.gdal.gdalJNI;
import org.gdal.osr.SpatialReference;

public class MDArray {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private Object parentReference;

    protected MDArray(long cPtr, boolean cMemoryOwn) {
        if (cPtr == 0L) {
            throw new RuntimeException();
        }
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MDArray obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                gdalJNI.delete_MDArray(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    protected static long getCPtrAndDisown(MDArray obj) {
        if (obj != null) {
            obj.swigCMemOwn = false;
            obj.parentReference = null;
        }
        return MDArray.getCPtr(obj);
    }

    protected void addReference(Object reference) {
        this.parentReference = reference;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof MDArray) {
            equal = ((MDArray)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String GetName() {
        return gdalJNI.MDArray_GetName(this.swigCPtr, this);
    }

    public String GetFullName() {
        return gdalJNI.MDArray_GetFullName(this.swigCPtr, this);
    }

    public BigInteger GetTotalElementsCount() {
        return gdalJNI.MDArray_GetTotalElementsCount(this.swigCPtr, this);
    }

    public long GetDimensionCount() {
        return gdalJNI.MDArray_GetDimensionCount(this.swigCPtr, this);
    }

    public ExtendedDataType GetDataType() {
        long cPtr = gdalJNI.MDArray_GetDataType(this.swigCPtr, this);
        return cPtr == 0L ? null : new ExtendedDataType(cPtr, true);
    }

    public Hashtable GetStructuralInfo() {
        return gdalJNI.MDArray_GetStructuralInfo(this.swigCPtr, this);
    }

    public Attribute GetAttribute(String name) {
        long cPtr = gdalJNI.MDArray_GetAttribute(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new Attribute(cPtr, true);
    }

    public Attribute CreateAttribute(String name, int nDimensions, SWIGTYPE_p_GUIntBig dimensions, ExtendedDataType data_type, Vector options) {
        long cPtr = gdalJNI.MDArray_CreateAttribute__SWIG_0(this.swigCPtr, this, name, nDimensions, SWIGTYPE_p_GUIntBig.getCPtr(dimensions), ExtendedDataType.getCPtr(data_type), data_type, options);
        return cPtr == 0L ? null : new Attribute(cPtr, true);
    }

    public Attribute CreateAttribute(String name, int nDimensions, SWIGTYPE_p_GUIntBig dimensions, ExtendedDataType data_type) {
        long cPtr = gdalJNI.MDArray_CreateAttribute__SWIG_1(this.swigCPtr, this, name, nDimensions, SWIGTYPE_p_GUIntBig.getCPtr(dimensions), ExtendedDataType.getCPtr(data_type), data_type);
        return cPtr == 0L ? null : new Attribute(cPtr, true);
    }

    public void GetNoDataValueAsDouble(Double[] val) {
        gdalJNI.MDArray_GetNoDataValueAsDouble(this.swigCPtr, this, val);
    }

    public String GetNoDataValueAsString() {
        return gdalJNI.MDArray_GetNoDataValueAsString(this.swigCPtr, this);
    }

    public int SetNoDataValueDouble(double d) {
        return gdalJNI.MDArray_SetNoDataValueDouble(this.swigCPtr, this, d);
    }

    public int SetNoDataValueString(String nodata) {
        return gdalJNI.MDArray_SetNoDataValueString(this.swigCPtr, this, nodata);
    }

    public int DeleteNoDataValue() {
        return gdalJNI.MDArray_DeleteNoDataValue(this.swigCPtr, this);
    }

    public void GetOffset(Double[] val) {
        gdalJNI.MDArray_GetOffset(this.swigCPtr, this, val);
    }

    public int GetOffsetStorageType() {
        return gdalJNI.MDArray_GetOffsetStorageType(this.swigCPtr, this);
    }

    public void GetScale(Double[] val) {
        gdalJNI.MDArray_GetScale(this.swigCPtr, this, val);
    }

    public int GetScaleStorageType() {
        return gdalJNI.MDArray_GetScaleStorageType(this.swigCPtr, this);
    }

    public int SetOffset(double val, int storageType) {
        return gdalJNI.MDArray_SetOffset(this.swigCPtr, this, val, storageType);
    }

    public int SetScale(double val, int storageType) {
        return gdalJNI.MDArray_SetScale(this.swigCPtr, this, val, storageType);
    }

    public int SetUnit(String unit) {
        return gdalJNI.MDArray_SetUnit(this.swigCPtr, this, unit);
    }

    public String GetUnit() {
        return gdalJNI.MDArray_GetUnit(this.swigCPtr, this);
    }

    public int SetSpatialRef(SpatialReference srs) {
        return gdalJNI.MDArray_SetSpatialRef(this.swigCPtr, this, SpatialReference.getCPtr(srs), srs);
    }

    public SpatialReference GetSpatialRef() {
        long cPtr = gdalJNI.MDArray_GetSpatialRef(this.swigCPtr, this);
        return cPtr == 0L ? null : new SpatialReference(cPtr, true);
    }

    public MDArray GetView(String viewExpr) {
        long cPtr = gdalJNI.MDArray_GetView(this.swigCPtr, this, viewExpr);
        return cPtr == 0L ? null : new MDArray(cPtr, true);
    }

    public MDArray Transpose(int[] nList) {
        long cPtr = gdalJNI.MDArray_Transpose(this.swigCPtr, this, nList);
        return cPtr == 0L ? null : new MDArray(cPtr, true);
    }

    public MDArray GetUnscaled() {
        long cPtr = gdalJNI.MDArray_GetUnscaled(this.swigCPtr, this);
        return cPtr == 0L ? null : new MDArray(cPtr, true);
    }

    public MDArray GetMask(Vector options) {
        long cPtr = gdalJNI.MDArray_GetMask__SWIG_0(this.swigCPtr, this, options);
        return cPtr == 0L ? null : new MDArray(cPtr, true);
    }

    public MDArray GetMask() {
        long cPtr = gdalJNI.MDArray_GetMask__SWIG_1(this.swigCPtr, this);
        return cPtr == 0L ? null : new MDArray(cPtr, true);
    }

    public Dataset AsClassicDataset(long iXDim, long iYDim) {
        long cPtr = gdalJNI.MDArray_AsClassicDataset(this.swigCPtr, this, iXDim, iYDim);
        return cPtr == 0L ? null : new Dataset(cPtr, true);
    }

    public Statistics GetStatistics(boolean approx_ok, boolean force, ProgressCallback callback) {
        long cPtr = gdalJNI.MDArray_GetStatistics(this.swigCPtr, this, approx_ok, force, callback);
        return cPtr == 0L ? null : new Statistics(cPtr, false);
    }

    public Statistics ComputeStatistics(boolean approx_ok, ProgressCallback callback) {
        long cPtr = gdalJNI.MDArray_ComputeStatistics(this.swigCPtr, this, approx_ok, callback);
        return cPtr == 0L ? null : new Statistics(cPtr, false);
    }

    public boolean Cache(Vector options) {
        return gdalJNI.MDArray_Cache__SWIG_0(this.swigCPtr, this, options);
    }

    public boolean Cache() {
        return gdalJNI.MDArray_Cache__SWIG_1(this.swigCPtr, this);
    }
}

